// CoinSlot.as

#include "MechanismsCommon.as";
#include "LootCommon.as";

enum state
{
	DISABLED = 0,
	POWERED
};

const u32 DURATION = 40;
const u8 COIN_COST = 60;

class CoinSlot : Component
{
	CoinSlot(Vec2f position)
	{
		x = position.x;
		y = position.y;
	}
};

void onInit(CBlob@ this)
{
	// used by BuilderHittable.as
	this.Tag("builder always hit");

	// used by BlobPlacement.as
	this.Tag("place norotate");

	// used by TileBackground.as
	this.set_TileType("background tile", CMap::tile_wood_back);

	// background, let water overlap
	this.getShape().getConsts().waterPasses = true;

	if(getNet().isServer())
	{
		addCoin(this, COIN_COST / 3);
	}

	this.addCommandID("activate");

	AddIconToken("$insert_coin$", "InteractionIcons.png", Vec2f(32, 32), 26);

	this.getCurrentScript().tickIfTag = "active";
}

void onSetStatic(CBlob@ this, const bool isStatic)
{
	if(!isStatic || this.exists("component")) return;

	const Vec2f POSITION = this.getPosition() / 8;

	CoinSlot component(POSITION);
	this.set("component", component);

	if(getNet().isServer())
	{
		MapPowerGrid@ grid;
		if(!getRules().get("power grid", @grid)) return;

		grid.setAll(
		component.x,                        // x
		component.y,                        // y
		TOPO_NONE,                          // input topology
		TOPO_CARDINAL,                      // output topology
		INFO_SOURCE,                        // information
		0,                                  // power
		0);                                 // id
	}

	CSprite@ sprite = this.getSprite();
	if(sprite is null) return;

	sprite.SetFacingLeft(false);
	sprite.SetZ(-50);
}

void GetButtonsFor(CBlob@ this, CBlob@ caller)
{
	if(!this.isOverlapping(caller) || !this.getShape().isStatic()) return;

	CPlayer@ player = caller.getPlayer();
	if(player !is null && player.isMyPlayer() && player.getCoins() < COIN_COST)
	{
		Sound::Play("NoAmmo.ogg");
		return;
	}

	CBitStream params;
	params.write_u16(player.getNetworkID());

	CButton@ button = caller.CreateGenericButton(
	"$insert_coin$",                            // icon token
	Vec2f_zero,                                 // button offset
	this,                                       // button attachment
	this.getCommandID("activate"),              // command id
	"Insert 60 coins",                          // description
	params);                                    // cbitstream parameters

	button.radius = 8.0f;
	button.enableRadius = 20.0f;
}

void onTick(CBlob@ this)
{
	if(!getNet().isServer() || this.get_u32("duration") > getGameTime()) return;

	Component@ component = null;
	if(!this.get("component", @component)) return;

	MapPowerGrid@ grid;
	if(!getRules().get("power grid", @grid)) return;

	this.Untag("active");

	this.set_u8("state", DISABLED);

	grid.setInfo(
	component.x,                        // x
	component.y,                        // y
	INFO_SOURCE);                       // information
}

void onCommand(CBlob@ this, u8 cmd, CBitStream @params)
{
	if(cmd == this.getCommandID("activate"))
	{
		if(getNet().isServer())
		{
			Component@ component = null;
			if(!this.get("component", @component)) return;

			MapPowerGrid@ grid;
			if(!getRules().get("power grid", @grid)) return;

			u16 id;
			if(!params.saferead_u16(id)) return;

			CPlayer@ player = getPlayerByNetworkId(id);
			if(player !is null)
			{
				player.server_setCoins(Maths::Max(player.getCoins() - COIN_COST, 0));
			}
			addCoin(this, COIN_COST / 3);

			this.Tag("active");

			this.set_u32("duration", getGameTime() + DURATION);

			this.set_u8("state", POWERED);

			grid.setInfo(
			component.x,                        // x
			component.y,                        // y
			INFO_SOURCE | INFO_ACTIVE);         // information
		}

		CSprite@ sprite = this.getSprite();
		if(sprite is null) return;

		sprite.SetAnimation("default");
		sprite.SetAnimation("activate");
		sprite.PlaySound("Cha.ogg");
	}
}

void onDie(CBlob@ this)
{
	if(getNet().isServer() && this.exists("component"))
	{
		server_CreateLoot(this, this.getPosition(), this.getTeamNum());
	}
}

bool canBePickedUp(CBlob@ this, CBlob@ byBlob)
{
	return false;
}